% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcFilterList-methods.R
\name{plot,fcFilterList,ANY-method}
\alias{plot,fcFilterList,ANY-method}
\title{plot a \code{fcFilterList}}
\usage{
\S4method{plot}{fcFilterList,ANY}(
  x,
  y,
  samples = NULL,
  posteriors = FALSE,
  xlim = NULL,
  ylim = NULL,
  node = NULL,
  data = NULL,
  breaks = 20,
  lwd = 1,
  ...
)
}
\arguments{
\item{x}{\code{fcFilterList}}

\item{y}{\code{character} channel name}

\item{samples}{\code{character} a vector of sample names to be plotted}

\item{posteriors}{\code{logical} indicating whether posteriors should be plotted}

\item{xlim, ylim}{scale settings for x,y axises}

\item{node}{\code{character} population name associated with the \code{fcFilterList}}

\item{data}{\code{GatingSet} object}

\item{breaks}{passed to \link{hist}}

\item{lwd}{line width}

\item{...}{other arguments passed to base \code{plot}}
}
\description{
It is usually called by \code{plot} method for \code{fcTree} instead of directly by users.
}
\examples{
\dontrun{ 
 env1<-new.env(parent=emptyenv())
 #gt is a gatingTemplate, gs is a GatingSet
 gt_gating(gt,gs,env1) #the flowClust gating results are stored in env1 
 plot(env1$fct,"nonDebris",post=T) #plot the priors as well as posteriors for the "nonDebris" gate
}
}
