% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gating-methods.R
\name{gt_gating}
\alias{gt_gating}
\alias{gt_gating.gatingTemplate}
\alias{gating}
\alias{gating,gatingTemplate,GatingSet-method}
\alias{gt_gating,gatingTemplate,GatingSet-method}
\title{Applies a gatingTemplate to a GatingSet.}
\usage{
gt_gating(x, y, ...)
}
\arguments{
\item{x}{a \code{gatingTemplate} object}

\item{y}{a \code{GatingSet} object}

\item{...}{\itemize{
    \item{start}{ a \code{character} that specifies the population (correspoding to 'alias' column in csv template) where the gating process will start from. It is useful to quickly skip some gates and go directly to the target population in the testing run. Default is "root".}
    \item{stop.at}{ a \code{character} that specifies the population (correspoding to 'alias' column in csv template) where the gating prcoess will stop at. Default is NULL, indicating the end of gating tree.}
    \item{keep.helperGates}{a \code{logical} flag indicating whether to keep the intermediate helper gates that are automatically generated by openCyto. Default is TRUE.}
    \item{mc.cores}{ passed to \code{multicore} package for parallel computing}
    \item{parallel_type}{  \code{character} specifying the parallel type. The valid options are "none", "multicore", "cluster".}
    \item{cl}{ \code{cluster} object passed to \code{parallel} package (when \code{parallel_type} is "cluster")}
}}
}
\value{
Nothing. As the side effect, gates generated by gating methods are saved in \code{GatingSet}.
}
\description{
It loads the gating methods by topological order and applies them to \code{GatingSet}.
}
\examples{
\dontrun{
 gt <- gatingTemplate(file.path(path, "data/ICStemplate.csv"), "ICS")
 gs <- GatingSet(fs) #fs is a flowSet/ncdfFlowSet
 gt_gating(gt, gs)
 gt_gating(gt, gs, stop.at = "v") #proceed the gating until population 'v'
 gt_gating(gt, gs, start = "v") # start from 'v'
 gt_gating(gt, gs, parallel_type = "multicore", mc.cores = 8) #parallel gating using multicore
 #parallel gating by using cluster
 cl1 <- makeCluster (8, type = "MPI")
 gt_gating(gt, gs, parallel_type = "cluster", cl = cl1)
 stopCluster ( cl1 )
}
}
