% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_pop.R
\name{gs_add_gating_method}
\alias{gs_add_gating_method}
\alias{add_pop}
\title{apply a gating method to the \code{GatingSet}}
\usage{
gs_add_gating_method(
  gs,
  alias = "*",
  pop = "+",
  parent,
  dims = NA,
  gating_method,
  gating_args = NA,
  collapseDataForGating = NA,
  groupBy = NA,
  preprocessing_method = NA,
  preprocessing_args = NA,
  strip_extra_quotes = FALSE,
  ...
)
}
\arguments{
\item{gs}{GatingSet or GatingSetList}

\item{alias, pop, parent, dims, gating_method, gating_args, collapseDataForGating, groupBy, preprocessing_method, preprocessing_args}{see details in \link[openCyto:gatingTemplate-class]{gatingTemplate}}

\item{strip_extra_quotes}{\code{logical} Extra quotes are added to strings by fread. This causes problems with parsing R strings to expressions in some cases. Default FALSE for usual behaviour. TRUE should be passed if parsing gating_args fails.}

\item{...}{other arguments
\itemize{
     \item{mc.cores}{ passed to \code{multicore} package for parallel computing}
     \item{parallel_type}{  \code{character} specifying the parallel type. The valid options are "none", "multicore", "cluster".}
     \item{cl}{ \code{cluster} object passed to \code{parallel} package (when \code{parallel_type} is "cluster")}
     }}
}
\description{
When interacting with the existing gated data, this function provides an alternative way to interact with the GatingSet 
by supplying the gating description directly through arguments without the need to write the complete
csv gating template.
}
\details{
Calls to \code{gs_add_gating_method} can also be easily reversed with \code{\link{gs_remove_gating_method}}. Note, however, that it is not possible
to differentiate between different \code{GatingSet} objects loaded from the same directory with 
\code{\link[flowWorkspace]{load_gs}} within a session. Thus, to guarantee a clean history for \code{gs_remove_gating_method}, 
it is necessary to call \code{\link{gs_add_gating_method_init}} on the loaded \code{GatingSet} immediately after re-loading it. 
See the documentation for \code{\link{gs_add_gating_method_init}} for more details. 
This will not be an issue for \code{GatingSet} objects created directly using the constructor.
}
\examples{
\dontrun{
# add quad gates 
gs_add_gating_method(gs, gating_method = "mindensity", dims = "CCR7,CD45RA", parent = "cd4-cd8+", pop = "CCR7+/-CD45RA+/-")

# polyfunctional gates (boolean combinations of exsiting marginal gates)
gs_add_gating_method(gs, gating_method = "polyFunctions", parent = "cd8", gating_args = "cd8/IFNg:cd8/IL2:cd8/TNFa")

#boolGate method
gs_add_gating_method(gs, alias = "IL2orIFNg", gating_method = "boolGate", parent = "cd4", gating_args = "cd4/IL2|cd4/IFNg") 
}
}
\seealso{
\code{\link{gs_remove_gating_method}} \code{\link{gs_add_gating_method_init}}
}
