% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/template_gating.R
\name{generate_gate_template}
\alias{generate_gate_template}
\title{Store gates from a GatingSet in a gatingTemplate for templated gating}
\usage{
generate_gate_template(
  x,
  groupBy = NA,
  nodes = NULL,
  gatingTemplate = FALSE,
  save_as = NULL,
  ...
)
}
\arguments{
\item{x}{a \code{GatingHierarchy} or \code{GatingSet} object.}

\item{groupBy}{a vector of variable names that exist in
\code{colnames(pData(x))} to split samples into groups before extracting
the gates specified by \code{nodes}, set to NA by default to produce
consensus gates across all samples.}

\item{nodes}{a vector of full node paths that exist in \code{x} for which
templated gating entries are required, set to all nodes in \code{x} by
default.}

\item{gatingTemplate}{logical to indicate whether a \code{gatingTemplate}
object should be returned, set to FALSE by default. \code{gatingTemplate}
objects can only be created when all nodes in \code{x} are specified.}

\item{save_as}{name of the CSV file to which the gatingTemplate entries
should be written, set to NULL to prevent the gatingTemplate from being
written to a CSV file.}

\item{...}{additional arguments passed to \code{\link{gatingTemplate-class}}.}
}
\value{
either a \code{data.table} or \code{gatingTemplate} object containing
  the requested gatingTemplate entries for downstream templated gating using
  \code{gt_gating()}.
}
\description{
\code{generate_gate_template()} iterates through samples groups in a
GatingSet to extract and store existing gates into an openCyto
\code{gatingTemplate} that can be easily applied to new GatingSets using
\code{gt_gating()}.
}
\examples{
\dontrun{
# gs contains variable BioSampleType
pData(gs)$BioSampleType <- rep(c("cells", "beads"), each = 4)
# create gatingTemplate object
gt <- generate_gate_template(
  gs,
  groupBy = "BioSampleType",
  gatingTemplate = TRUE,
  save_as = "gatingTemplate.csv"
)
# gt is a gatingTemplate object
gt
# apply gt to a new GatingSet
gt_gating(
  gt,
  gs_new
)
}

}
\author{
Dillon Hammill, \email{Dillon.Hammill@ozette.com}
}
