% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gating-functions.R
\name{gate_flowclust_2d}
\alias{gate_flowclust_2d}
\alias{gate_flowClust_2d}
\alias{flowClust.2d}
\title{Automatic identification of a population of interest via flowClust based on
two markers}
\usage{
gate_flowclust_2d(
  fr,
  xChannel,
  yChannel,
  filterId = "",
  K = 2,
  usePrior = "no",
  prior = list(NA),
  trans = 0,
  min.count = -1,
  max.count = -1,
  nstart = 1,
  plot = FALSE,
  target = NULL,
  transitional = FALSE,
  quantile = 0.9,
  translation = 0.25,
  transitional_angle = NULL,
  min = NULL,
  max = NULL,
  ...
)
}
\arguments{
\item{fr}{a \code{flowFrame} object}

\item{xChannel, yChannel}{\code{character} specifying channels to be gated on}

\item{filterId}{A \code{character} string that identifies the filter created.}

\item{K}{the number of clusters to find}

\item{usePrior}{Should we use the Bayesian version of \code{\link{flowClust}}?
Answers are "yes", "no", or "vague". The answer is passed along to
\code{\link{flowClust}}.}

\item{prior}{list of prior parameters for the Bayesian version of
\code{\link{flowClust}}. If \code{usePrior} is set to \code{no}, then the
list is unused.}

\item{trans, min.count, max.count, nstart}{some flowClust parameters. see \code{\link{flowClust}}}

\item{plot}{a logical value indicating if the fitted mixture model should be
plotted. By default, no.}

\item{target}{a numeric vector of length \code{2} (number of dimensions) containing the location of
the cluster of interest. See details.}

\item{transitional}{logical value indicating if a transitional gate should be
constructed from the target \code{\link{flowClust}} cluster. By default, no.}

\item{quantile}{the contour level of the target cluster from the
\code{\link{flowClust}} fit to construct the gate}

\item{translation}{a numeric value between 0 and 1 used to position a
transitional gate if \code{transitional = TRUE}. This argument is ignored if
\code{transitional = FALSE}. See details}

\item{transitional_angle}{the angle (in radians) of the transitional
gate. It is also used to determine which quadrant the final gate resides in.
See details. Ignored if \code{transitional = FALSE}.}

\item{min}{A vector of length 2. Truncate observations less than this minimum
value. The first value truncates the \code{xChannel}, and the second value
truncates the \code{yChannel}. By default, this vector is \code{NULL} and is
ignored.}

\item{max}{A vector of length 2. Truncate observations greater than this
maximum value. The first value truncates the \code{xChannel}, and the second
value truncates the \code{yChannel}. By default, this vector is \code{NULL}
and is ignored.}

\item{...}{additional arguments that are passed to \code{\link{flowClust}}}
}
\value{
a \code{polygonGate} object containing the contour (ellipse) for 2D
gating.
}
\description{
We cluster the observations in \code{fr} into \code{K} clusters. We set the
cutpoint to be the point at which the density between the first and second
smallest cluster centroids is minimum.
}
\details{
The cluster for the population of interest is selected as the one with
cluster centroid nearest the \code{target} in Euclidean distance. By default,
the largest cluster (i.e., the cluster with the largest proportion of
observations) is selected as the population of interest.

We also provide the option of constructing a \code{transitional} gate from
the selected population of interest. The location of the gate can be
controlled with the \code{translation} argument, which translates the gate
along the major axis of the targest cluster as a function of the appropriate
chi-squared coefficient. The larger \code{translation} is, the more gate is
shifted in a positive direction. Furthermore, the width of the
\code{transitional} gate can be controlled with the \code{quantile} argument.

The direction of the transitional gate can be controlled with the
\code{transitional_angle} argument. By default, it is \code{NULL}, and we use
the eigenvector of the \code{target} cluster that points towards the first
quadrant (has positive slope). If \code{transitional_angle} is specified, we
rotate the eigenvectors so that the angle between the x-axis (with the cluster
centroid as the origin) and the major eigenvector (i.e., the eigenvector with
the larger eigenvalue) is \code{transitional_angle}. 
So based on range that the angle falls in, the final rectangleGate will be constructed 
at the corresponding quadrant. i.e. Clockwise, [0,pi/2] UR, (pi/2, pi] LR,
(pi, 3/2 * pi] LL, (3/2 * pi, 2 * pi] UL
}
\examples{
\dontrun{
 gate <- gate_flowclust_2d(fr, xChannel = "FSC-A", xChannel = "SSC-A", K = 3) # fr is a flowFrame
}
}
