% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LORDstar.R
\name{LORDstar}
\alias{LORDstar}
\title{LORDstar: Asynchronous online mFDR control based on recent discovery}
\usage{
LORDstar(
  d,
  alpha = 0.05,
  version,
  gammai,
  w0,
  batch.sizes,
  display_progress = FALSE
)
}
\arguments{
\item{d}{Either a vector of p-values, or a dataframe with three columns: an
identifier (`id'), 
p-value (`pval'), and either 
`decision.times', or
`lags', depending on which version you're using. See version for more details.}

\item{alpha}{Overall significance level of the procedure, the default is
0.05.}

\item{version}{Takes values 'async', 'dep' or 'batch'. This specifies the
  version of LORDstar to use. \code{version='async'} requires a 
column of decision times (`decision.times'). \code{version='dep'} requires a
column of lags (`lags').
\code{version='batch'} requires a vector of batch sizes (`batch.sizes').}

\item{gammai}{Optional vector of \eqn{\gamma_i}. A default is provided as
proposed by Javanmard and Montanari (2018), equation 31.}

\item{w0}{Initial `wealth' of the procedure, defaults to \eqn{\alpha/10}.}

\item{batch.sizes}{A vector of batch sizes, this is required for
\code{version='batch'}.}

\item{display_progress}{Logical. If \code{TRUE} prints out a progress bar for the algorithm runtime.}
}
\value{
\item{out}{A dataframe with the original p-values \code{pval}, the
adjusted testing levels \eqn{\alpha_i} and the indicator function of
discoveries \code{R}. Hypothesis \eqn{i} is rejected if the \eqn{i}-th
p-value is less than or equal to \eqn{\alpha_i}, in which case \code{R[i] =
1}  (otherwise \code{R[i] = 0}).}
}
\description{
Implements LORD algorithms for asynchronous online testing, as presented by
Zrnic et al. (2021).
}
\details{
The function takes as its input either a vector of p-values, or a dataframe
with three columns: an identifier (`id'),
p-value (`pval'), and a column describing the conflict sets for the hypotheses. 
This takes the form of a vector of decision times or lags. Batch sizes can be 
specified as a separate argument (see below).

Zrnic et al. (2021) present explicit three versions of LORDstar:

1) \code{version='async'} is for an asynchronous testing process, consisting
of tests that start and finish at (potentially) random times. The discretised
finish times of the test correspond to the decision times. These decision
times are given as the input \code{decision.times} for this version of the
LORDstar algorithm.

2) \code{version='dep'} is for online testing under local dependence of the
p-values. More precisely, for any \eqn{t>0} we allow the p-value \eqn{p_t} to
have arbitrary dependence on the previous \eqn{L_t} p-values. The fixed
sequence \eqn{L_t} is referred to as `lags', and is given as the input
\code{lags} for this version of the LORDstar algorithm.

3) \code{version='batch'} is for controlling the mFDR in mini-batch testing,
where a mini-batch represents a grouping of tests run asynchronously which
result in dependent p-values. Once a mini-batch of tests is fully completed,
a new one can start, testing hypotheses independent of the previous batch.
The batch sizes are given as the input \code{batch.sizes} for this version of
the LORDstar algorithm.

Given an overall significance level \eqn{\alpha}, LORDstar depends on
\eqn{w_0} (where \eqn{0 \le w_0 \le \alpha}), which represents the intial
`wealth' of the procedure. The algorithms also require a sequence of
non-negative non-increasing numbers \eqn{\gamma_i} that sum to 1.

Note that these LORDstar algorithms control the \emph{modified} FDR (mFDR).
The `async' version also controls the usual FDR if the p-values are assumed
to be independent.

Further details of the LORDstar algorithms can be found in Zrnic et al.
(2021).
}
\examples{
sample.df <- data.frame(
id = c('A15432', 'B90969', 'C18705', 'B49731', 'E99902',
    'C38292', 'A30619', 'D46627', 'E29198', 'A41418',
    'D51456', 'C88669', 'E03673', 'A63155', 'B66033'),
pval = c(2.90e-08, 0.06743, 0.01514, 0.08174, 0.00171,
        3.60e-05, 0.79149, 0.27201, 0.28295, 7.59e-08,
        0.69274, 0.30443, 0.00136, 0.72342, 0.54757),
decision.times = seq_len(15) + 1)

LORDstar(sample.df, version='async')

sample.df2 <- data.frame(
id = c('A15432', 'B90969', 'C18705', 'B49731', 'E99902',
    'C38292', 'A30619', 'D46627', 'E29198', 'A41418',
    'D51456', 'C88669', 'E03673', 'A63155', 'B66033'),
pval = c(2.90e-08, 0.06743, 0.01514, 0.08174, 0.00171,
        3.60e-05, 0.79149, 0.27201, 0.28295, 7.59e-08,
        0.69274, 0.30443, 0.00136, 0.72342, 0.54757),
lags = rep(1,15))

LORDstar(sample.df2, version='dep')

}
\references{
Javanmard, A. and Montanari, A. (2018) Online Rules for Control
of False Discovery Rate and False Discovery Exceedance. \emph{Annals of
Statistics}, 46(2):526-554.

Zrnic, T., Ramdas, A. and Jordan, M.I. (2021). Asynchronous Online Testing of
Multiple Hypotheses. \emph{Journal of Machine Learning Research} 22:1-33.
}
\seealso{
\code{\link{LORD}} presents versions of LORD for \emph{synchronous} p-values,
i.e. where each test can only start when the previous test has finished.
}
