% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflow_oncoscan.R
\name{workflow_oncoscan.chas}
\alias{workflow_oncoscan.chas}
\title{Run the standard workflow for Oncoscan ChAS files.}
\usage{
workflow_oncoscan.chas(chas.fn)
}
\arguments{
\item{chas.fn}{Path to the text-export ChAS file}
}
\value{
A list of lists with the following elements:
\code{armlevel = list(AMP= list of arms, GAIN= list of arms, LOSS= list of
arms, LOH= list of arms),
scores = list(LST= number, LOH= number, TDplus= number, TD= number),
file = path of the ChAS file as given by the parameter)}
}
\description{
Run the standard workflow for Oncoscan ChAS files.
}
\details{
Identifies the globally altered arms (\>=90\% of arm altered),
computes the HRD and TD+ scores. The amplification is defined as a CN subtype
 \code{cntype.weakamp} or \code{cntype.strongamp}. An arm is gained if of CN
 type \code{cntype.gain} unless the arm is amplified.
}
\examples{
segs.filename <- system.file('extdata', 'chas_example.txt',
package = 'oncoscanR')
workflow_oncoscan.chas(segs.filename)
}
