% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input.R
\name{trim_to_coverage}
\alias{trim_to_coverage}
\title{Trim segments with respect to the kit's coverage.}
\usage{
trim_to_coverage(segments, kit.coverage)
}
\arguments{
\item{segments}{A \code{GRanges} object containing the segments, their copy
number and copy number types.}

\item{kit.coverage}{A \code{GRanges} object containing the regions covered on
each chromosome arm.}
}
\value{
A \code{GRanges} object containing the cleaned segments, their copy
number and copy number types.
}
\description{
Trim segments with respect to the kit's coverage.
}
\details{
All segments that are not entirely contained within the kit coverage
 will be trimmed to the coverage's limits.
}
\examples{
segs.trimmed <- trim_to_coverage(segs.chas_example, oncoscan_na33.cov)
}
