% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores.R
\name{score_loh}
\alias{score_loh}
\title{Compute the number HR deficiency-associated LOH regions.}
\usage{
score_loh(segments, arms.loh, arms.hetloss, kit.coverage)
}
\arguments{
\item{segments}{A \code{GRanges} object containing the segments, their copy
number and copy number types.}

\item{arms.loh}{A list of arms with global/arm-level LOH alteration.}

\item{arms.hetloss}{A list of arms with global/arm-level heterozygous
losses.}

\item{kit.coverage}{A \code{GRanges} object containing the regions covered on
each chromosome arm.}
}
\value{
An integer representing the number of HRD-LOH regions.
}
\description{
Compute the number HR deficiency-associated LOH regions.
}
\details{
Procedure based on the paper from Abkevich et al., Br J Cancer 2012
(PMID: 23047548). All LOH segments larger than 15Mb but excluding chromosome
with a global LOH alteration (to compute with the \code{armlevel_alt}
function on LOH segments only). This score was linked to BRCA1/2-deficient
tumors.
Note that the function will merge overlapping or neighbor LOH segments (at a
distance of 1bp).
}
\examples{
armlevel.loh <- armlevel_alt(get_loh_segments(segs.chas_example),
                             kit.coverage = oncoscan_na33.cov)
armlevel.hetloss <- armlevel_alt(get_hetloss_segments(segs.chas_example),
                             kit.coverage = oncoscan_na33.cov)
score_loh(segs.chas_example, names(armlevel.loh), names(armlevel.hetloss),
oncoscan_na33.cov)
}
