% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores.R
\name{score_gloh}
\alias{score_gloh}
\title{Compute the genomic LOH score.}
\usage{
score_gloh(segments, arms.loh, arms.hetloss, kit.coverage)
}
\arguments{
\item{segments}{A \code{GRanges} object containing the segments, their copy
number and copy number types.}

\item{arms.loh}{A list of arms with global/arm-level LOH alteration.}

\item{arms.hetloss}{A list of arms with global/arm-level heterozygous
loss.}

\item{kit.coverage}{A \code{GRanges} object containing the regions covered on
each chromosome arm.}
}
\value{
An integer representing the percentage of LOH bases.
}
\description{
Compute the genomic LOH score.
}
\details{
The percentage genomic LOH score is computed as described in the
FoundationFocus CDx BRCA LOH assay; i.e. the percentage of bases covered by
the Oncoscan that display a loss of heterozygosity independently of the
number of copies, excluding chromosomal arms that have a global LOH (>=90% of
arm length).
To compute with the \code{armlevel_alt} function on LOH segments only).
This score was linked to BRCA1/2-deficient tumors.
}
\examples{
armlevel.loh <- armlevel_alt(get_loh_segments(segs.chas_example),
                             kit.coverage = oncoscan_na33.cov)
armlevel.hetloss <- armlevel_alt(get_hetloss_segments(segs.chas_example),
                             kit.coverage = oncoscan_na33.cov)
score_gloh(segs.chas_example, names(armlevel.loh), names(armlevel.hetloss),
oncoscan_na33.cov)
}
