% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input.R
\name{get_oncoscan_coverage_from_bed}
\alias{get_oncoscan_coverage_from_bed}
\title{Load the oncoscan coverage BED file into a GenomicRanges object.}
\usage{
get_oncoscan_coverage_from_bed(filename)
}
\arguments{
\item{filename}{Path to the coverage BED file.}
}
\value{
A \code{GRanges} object containing the regions covered on each
chromosome arm.
}
\description{
Load the oncoscan coverage BED file into a GenomicRanges object.
}
\details{
Expects the following columns from the BED file (no header):
  1. Name of the chromosomal arm (e.g. "1p")
  2. Start position of the arm
  3. End position of the arm
}
\examples{
oncoscan_na33.cov <- get_oncoscan_coverage_from_bed(
       system.file('extdata', 'Oncoscan.na33.r2.cov.processed.bed',
       package = 'oncoscanR'))
}
