% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxi_gsAnnotatedDF.R
\name{gsAnnotIdList}
\alias{gsAnnotIdList}
\title{Annotation of gene/protein function using multiple IDs.}
\usage{
gsAnnotIdList(
  idList,
  gsIdMap,
  minSize = 5,
  maxSize = 500,
  data.frame = FALSE,
  sparse = TRUE
)
}
\arguments{
\item{idList}{list of protein IDs, e.g. list(c("ID1", "ID2"), c("ID13"), c("ID4", "ID8", "ID10"))}

\item{gsIdMap}{a data frame for geneset to id map, it has two columns
- id: the ID column
- term: annotation terms
e.g. 
gsIdMap <- data.frame(
  id = c("ID1", "ID2", "ID1", "ID2", "ID8", "ID10"),
  term = c("T1", "T1", "T2", "T2", "T2", "T2"),
  stringsAsFactors = FALSE
  )}

\item{minSize}{minimum size of gene sets}

\item{maxSize}{maximum size of gene sets}

\item{data.frame}{logical; whether to organize the result into \code{data.frame} format, 
see "Value" section.}

\item{sparse}{logical; whether to return a sparse matrix, only used when data.frame=FALSE}
}
\value{
A binary matrix (if \code{data.frame} = FALSE),
the number of rows is the same with length of idList, the columns 
are the annotated gene set; or a \code{data.frame} (if \code{data.frame} = 
TRUE) with three columns: featureId, gsId, weight.
}
\description{
Annotation of gene/protein function using multiple IDs.
}
\examples{
terms <- data.frame(
  id = c("ID1", "ID2", "ID1", "ID2", "ID8", "ID10"),
 term = c("T1", "T1", "T2", "T2", "T2", "T2"),
  stringsAsFactors = FALSE
)
features <- list(c("ID1", "ID2"), c("ID13"), c("ID4", "ID8", "ID10"))
gsAnnotIdList(idList = features, gsIdMap = terms, minSize = 1, maxSize = 500)

terms <- data.frame(
id = c("ID1", "ID2", "ID1", "ID2", "ID8", "ID10", "ID4", "ID4"),
term = c("T1", "T1", "T2", "T2", "T2", "T2", "T1", "T2"),
stringsAsFactors = FALSE
)
features <- list(F1 = c("ID1", "ID2", "ID4"), F2 = c("ID13"), F3 = c("ID4", "ID8", "ID10"))
gsAnnotIdList(features, gsIdMap = terms, data.frame = TRUE, minSize = 1)
gsAnnotIdList(features, gsIdMap = terms, data.frame = FALSE, minSize = 1)

}
