% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{hm450.manifest.pop.GoNL}
\alias{hm450.manifest.pop.GoNL}
\title{HM450 population-specific probe-masking recommendations}
\format{A GRanges object with 485577 ranges and 65 metadata columns:
\describe{
  \item{MASK.general.pop}{Recommended general purpose masking merged from 
       "MASK.sub30.copy", "MASK.mapping" (in either the hg38 or hg19 
       genome), "MASK.extBase", "MASK.typeINextBaseSwitch" and 
       "MASK.snp5.pop" from the "hm450.manifest" file and the 
       "hm450.manifest.pop" file (see source).For GoNL, 
       "MASK.typeINextBaseSwitchandINDEL.GoNL" is used instead of 
       "MASK.typeINextBaseSwitch"}
  \item{MASK.snp5.pop}{Whether the 5bp 3'-subsequence (including extension 
        for type II) overlap with a SNP with population-specific AF > 0.01}
  \item{MASK.typeINextBaseSwitchandINDEL.GoNL}{SNPs (that cause a 
       color-channel switch) and INDELS with AF > 0.01 in GoNL.  In 
       contrast, "MASK.typeINextBaseSwitch" column is based on all SNPs in 
       1000 genomes and dbSNP, regardless of population or allele frequency}
}}
\source{
\url{http://zwdzwd.github.io/InfiniumAnnotation}
}
\usage{
data(hm450.manifest.pop.GoNL)
}
\description{
Adapted version of the annotation file provided by Zhou et al. (see
source, Mar-13-2017 release).  This annotation file contains
population-specific probe-masking recommendations based on SNPs
within 5 bases from the 3'end of the probe, mapping issues,
non-unique 3' 30bp subsequence and channel-switching SNPs in the
single-base-extension for type I probes. We added
population-specific masking recommendations for the Dutch
population using GoNL release 5. This release does not include X
and Y chromosomes, so for the Dutch population, only masking
information for the autosomal probes is available.
}
\details{
Note: Zhou et al. identified several probes that match to a
different location than annotated in the original Illumina manifest
file. The authors have used the 'updated' location in their
annotation file. Therefore, a handful of probes in this annotation
file are annotated to a different location than the original
Illumina manifest file. For the identification of the overlaps we
used the locations as annotated in the original Illumina file.
Therefore, a few of the identified overlaps do not match the
locations as specified in this annotation file.  This also explains
why GoNL masking information is available for a couple of probes
that are located in the X- and Y-chromosome in this annotation:
these probes map to autosomal probes in the original Illumina
file. All probes that map to a different location than originally
annotated are recommended to be masked (in the MASK.mapping and
MASK.general column), so generally they won't be included in
further analyses.
}
\examples{
# Select probes that should be masked in Dutch population 
# (note that X and Y chromosomes are not included)
hm450.manifest.pop.GoNL <- hm450.manifest.pop.GoNL[!is.na(
    hm450.manifest.pop.GoNL$MASK.general.GoNL) &
    hm450.manifest.pop.GoNL$MASK.general.GoNL == TRUE, ]
  
# Select probes that should be masked in Dutch population because there is 
# a SNP within 5 bases of the 3'end of the probe 
# (note that X and Y chromosomes are not included)
hm450.manifest.pop.GoNL <- hm450.manifest.pop.GoNL[!is.na(
    hm450.manifest.pop.GoNL$MASK.snp5.GoNL) &
    hm450.manifest.pop.GoNL$MASK.snp5.GoNL == TRUE, ]
    
# When studying a Dutch population and one wants to include X and Y 
# chromosomal probes, the EUR or CEU population can be used.                                                      
# Select probes that should be masked in European population 
# (these include X and Y chromosomes)                                                      
hm450.manifest.pop.GoNL <- hm450.manifest.pop.GoNL[
    hm450.manifest.pop.GoNL$MASK.general.EUR == TRUE,]


}
\references{
Zhou W, Laird PW and Shen H: Comprehensive characterization, 
    annotation and innovative use of Infinium DNA Methylation BeadChip 
    probes.
    Nucleic Acids Research 2016
}
\keyword{datasets}
