% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genotyping.R
\name{beta2genotype}
\alias{beta2genotype}
\title{converts beta-values to genotypes (1, 2 and 3)}
\usage{
beta2genotype(betas, na.rm = TRUE, minSep = 0.25, minSize = 5,
  centers = c(0.2, 0.5, 0.8), assayName = NULL)
}
\arguments{
\item{betas}{beta matrix of probes possibly affected SNPs; if this is a
SummarizedExperiment or a MultiAssayExperiment assayName must also be
specified}

\item{na.rm}{TRUE drop cpg for which no clustering was observed}

\item{minSep}{minimal separation between clusters}

\item{minSize}{size of smallest cluster (in percentage)}

\item{centers}{center of clusters, defaults to 0.2, 0.5, 0.8.}

\item{assayName}{the name of the assay to be used (see betas)}
}
\value{
matrix with genotypes
}
\description{
convert DNA methylation beta-value to inferred genotypes
}
\details{
Using kmeans unsupervised clustering to infer genotypes based on
idea's from Leonard Schalkwyk; wateRmelon packages.

'minSep' and 'minSize' ensure good clusters are found.
This function is similar to the gaphunter approach implemented in minfi.
}
\examples{
set.seed(12345)
beta <- matrix(runif(100*10, 0,1), nrow=100)
beta[1:5, 1:5]
genotype <- beta2genotype(beta)
genotype[1:5, 1:5]
}
\author{
mvaniterson
}
