% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_AllMethods.R, R/ResultSet-tableLambda.R
\docType{methods}
\name{tableLambda}
\alias{tableLambda}
\alias{tableLambda,ResultSet-method}
\alias{tableLambda}
\title{Compute a lambda score on the results stored in a ResultSet}
\usage{
tableLambda(object, trim = 0.5)

\S4method{tableLambda}{ResultSet}(object, trim = 0.5)
}
\arguments{
\item{object}{An object of class \link{ResultSet}}

\item{trim}{(default \code{0.5}) percentage of right omited values for
\link{lambdaClayton}.}
}
\value{
Returns a \code{data.frame} having the exposures and the computed
lambda score.

A labeled numeric vector with the lambda score for each exposure.
}
\description{
Compute lambda score on each result in the given \link{ResultSet} by using
\code{lambdaClayton}.
}
\examples{
data("asr", package = "omicRexposome")
tableLambda(asr)
}
\seealso{
\code{\link{tableHits}} for the number of hits per analysys,
\code{\link{plotHits}} for a graphical representation of the hists
per analysys, \code{\link{plotLambda}} for a graphical representation of
the lambda score per analysys
}
