% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omXplore_heatmap.R, R/plot_heatmap.R
\name{omXplore_heatmap}
\alias{omXplore_heatmap}
\alias{omXplore_heatmap_ui}
\alias{omXplore_heatmap_server}
\alias{heatmapD}
\alias{mv.heatmap}
\alias{heatmapForMissingValues}
\title{Displays a correlation matrix of the quantitative data of a
numeric matrix.}
\usage{
omXplore_heatmap_ui(id)

omXplore_heatmap_server(
  id,
  dataIn = reactive({
     NULL
 }),
  i = reactive({
     NULL
 })
)

omXplore_heatmap(dataIn, i)

heatmapD(
  qdata,
  conds,
  distance = "euclidean",
  cluster = "complete",
  dendro = FALSE
)

mv.heatmap(
  x,
  col = grDevices::heat.colors(100),
  srtCol = NULL,
  labCol = NULL,
  labRow = NULL,
  key = TRUE,
  key.title = NULL,
  main = NULL,
  ylab = NULL
)

heatmapForMissingValues(
  x,
  col = NULL,
  srtCol = NULL,
  labCol = NULL,
  labRow = NULL,
  key = TRUE,
  key.title = NULL,
  main = NULL,
  ylab = NULL
)
}
\arguments{
\item{id}{A \code{character(1)} which is the id of the shiny module.}

\item{dataIn}{An instance of a class \code{MultiAssayExperiment}.}

\item{i}{An integer which is the index of the assay in the param obj}

\item{qdata}{A data.frame() of quantitative data.}

\item{conds}{A vector indicating the name of each sample.}

\item{distance}{The distance used by the clustering algorithm to compute
the dendrogram.}

\item{cluster}{the clustering algorithm used to build the dendrogram.}

\item{dendro}{A boolean to indicate fi the dendrogram has to be displayed}

\item{x}{A \code{matrix} or \code{array} containing the quantitative data.}

\item{col}{Colors used for the image. Defaults to heat colors (heat.colors).}

\item{srtCol}{Angle of column conds, in degrees from horizontal}

\item{labCol}{Character vectors with column conds to use.}

\item{labRow}{Character vectors with row conds to use.}

\item{key}{Logical indicating whether a color-key should be shown.}

\item{key.title}{Main title of the color key. If set to NA no title will
be plotted.}

\item{main}{Main title; default to none.}

\item{ylab}{y-axis title; default to none.}
}
\value{
NA

NA

A shiny app

A heatmap

A heatmap

A heatmap
}
\description{
This function is a wrapper to \code{heatmap.2()} that displays
assay data in an instance of \code{SummarizedExperiment}. For
more details, see \code{heatmap.2()}.
}
\examples{
if (interactive()) {
    data(vdata)
    omXplore_heatmap(vdata, 1)
}

}
\author{
Florence Combes, Samuel Wieczorek, Enora Fremy
}
