% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootHelper.R
\name{oneRegionSegment}
\alias{oneRegionSegment}
\title{Segmentation based on one region}
\usage{
oneRegionSegment(x, seqlength)
}
\arguments{
\item{x}{a single region as GRanges object}

\item{seqlength}{optional, the length of the chromosome,
if not provided, the function will attempt to pull this
using \code{genome(x)} and the \code{Seqinfo} function}
}
\value{
a segmentation (GRanges object) with the region of
interest designated as state 2, and the rest of the chromosome
as state 1.
}
\description{
This function makes a segmentation (GRanges) based on one
region of one chromosome (seqnames).
}
\examples{

library(GenomicRanges)
x <- GRanges("chr1", IRanges(10e6+1,width=1e6))
genome(x) <- "hg19"
seg <- oneRegionSegment(x)

}
