#' @section Accessor methods for Matched subclass objects:
#' Additional functions that get data from Matched subclasses
#' (`x`) such as MatchedDataFrame, MatchedGRanges,
#' and MatchedGInteractions include:
#' \itemize{
#'   \item `focal(x)`: Get focal set from a Matched object
#'   \item `pool(x)`: Get pool set from a Matched object
#'   \item `matched(x)`: Get matched set from a Matched object
#'   \item `unmatched(x)`: Get unmatched set from a Matched object
#' }
#' For more detail check the help pages for these functions.
#' 
#' @examples 
#' ## Accessor functions for Matched subclasses
#' focal(x)
#' pool(x)
#' matched(x)
#' unmatched(x)
#' 
#' @seealso [focal], [pool], [matched], [unmatched]
