% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readBAM.R
\name{readBAM}
\alias{readBAM}
\title{Import reads from a list of BAM files.}
\usage{
readBAM(files, type = "paired")
}
\arguments{
\item{files}{List of input BAM files.}

\item{type}{Describes the type of reads. Values allowed are \code{single} for
single-ended reads and \code{paired} for pair-ended.}
}
\value{
\link[GenomicRanges:GRangesList]{GenomicRanges::GRangesList} containing the reads of each input BAM
file.
}
\description{
This function allows to load reads from BAM files from both single and
paired-end commming from Next Generation Sequencing nucleosome mapping
experiments.
}
\examples{
infile <- system.file(
    "extdata", "cellCycleM_chrII_5000-25000.bam", package="nucleR"
)
reads <- readBAM(infile, type="paired")

}
\author{
Ricard Illa \email{ricard.illa@irbbarcelona.org}
}
\keyword{file}
