% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformations.R
\name{mark_nas}
\alias{mark_nas}
\title{Mark specified values as missing}
\usage{
mark_nas(object, value, assay.type = NULL, name = NULL)
}
\arguments{
\item{object}{a \code{
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object}

\item{value}{the value to be converted to NA}

\item{assay.type}{character, assay to be used in case of multiple assays}

\item{name}{character, name of the resultant assay in case of multiple assays}
}
\value{
SummarizedExperiment object as the one supplied, with 
missing values correctly set to NA.
}
\description{
Replaces all values in the peak table that equal the specified value 
with NA.
For example, vendor software might use 0 or 1 to signal a missing value,
which is not understood by R.
}
\examples{
data(toy_notame_set)
nas_marked <- mark_nas(toy_notame_set, value = 0)

}
