% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_constructor.R
\name{join_rowData}
\alias{join_rowData}
\title{Join new columns to feature data}
\usage{
join_rowData(object, dframe)
}
\arguments{
\item{object}{a \code{
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}}

\item{dframe}{a data frame with the new information}
}
\value{
A SummarizedExperiment object with the new information added to 
rowData(object).
}
\description{
Join a new data frame of information to feature data of a 
SummarizedExperiment object. The data frame needs to have a column 
"Feature_ID". This function is usually used internally by some of the 
functions in the package, but can be useful.
}
\examples{
data(toy_notame_set)
new_info <- data.frame(
  Feature_ID = rownames(toy_notame_set),
  Feature_number = seq_len(nrow(toy_notame_set))
)
with_new_info <- join_rowData(toy_notame_set, new_info)
colnames(rowData(with_new_info))

}
