% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quality_metrics.R
\name{flag_detection}
\alias{flag_detection}
\title{Flag features with low detection rate}
\usage{
flag_detection(
  object,
  qc_limit = 0.7,
  group_limit = 0.5,
  group = NULL,
  assay.type = NULL
)
}
\arguments{
\item{object}{a \code{
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object}

\item{qc_limit}{the detection rate limit for QC samples}

\item{group_limit}{the detection rate limit for study groups}

\item{group}{the columns name in sample information to use as the grouping 
variable}

\item{assay.type}{character, assay to be used in case of multiple assays}
}
\value{
A SummarizedExperiment object with the features flagged.
}
\description{
Flags features with too high amount of missing values. There are two 
detection rate limits, both defined as the minimum proportion of samples 
that need to have a value (not NA) for the feature to be kept. 
'\code{qc_limit} is the detection rate limit for QC samples, 
'\code{group_limit} is the detection rate limit for the actual study groups.
If the group limit is passed for AT LEAST ONE GROUP, then the feature is 
kept. Features with low detection rate in QCs are flagged as 
"Low_qc_detection", while low detection rate in the study groups is flagged 
as "Low_group_detection". The detection rates for all the groups are 
recorded in feature data.
}
\examples{
data(toy_notame_set)
ex_set <- mark_nas(toy_notame_set, value = 0)
ex_set <- flag_detection(ex_set, group = "Group")
rowData(ex_set)

}
