% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_load_plot.R
\name{vis_load_plot}
\alias{vis_load_plot}
\title{Visualize all loadings on two factor axes}
\usage{
vis_load_plot(
  mcia_results,
  axes = c(1, 2),
  color_pal = scales::viridis_pal,
  color_pal_params = list()
)
}
\arguments{
\item{mcia_results}{object returned from nipals_multiblock() function}

\item{axes}{list of two numbers associated with two factors to visualize}

\item{color_pal}{a list of colors or function which returns a list of colors}

\item{color_pal_params}{a list of parameters for the color function}
}
\value{
Plot of MCIA feature loadings for chosen axes
}
\description{
Visualize all loadings recovered from
nipalsMCIA() output loadings matrix ranked using across two factor axes
}
\examples{
data(NCI60)
data_blocks_mae <- simple_mae(data_blocks,row_format="sample",
                              colData=metadata_NCI60)
mcia_results <- nipals_multiblock(data_blocks_mae, num_PCs = 10,
                                  plots = "none", tol = 1e-12)
vis_load_plot(mcia_results, axes = c(1, 4))
}
