% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmb_accessors.R
\name{nmb_get_gl}
\alias{nmb_get_gl}
\title{Accessor function for global loadings}
\usage{
nmb_get_gl(nmb_object)
}
\arguments{
\item{nmb_object}{A `NipalsResult` object.}
}
\value{
a matrix containing global loadings.
}
\description{
Retrieves the global loadings as a matrix from a `NipalsResult`
object, typically output from `nipals_multiblock()`.
}
\examples{
data("NCI60")
data_blocks_mae <- simple_mae(data_blocks,row_format="sample",
                   colData=metadata_NCI60)
mcia_out <- nipals_multiblock(data_blocks_mae, num_PCs = 10)
global_loadings <- nmb_get_gl(mcia_out)
}
