% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmb_accessors.R
\name{nmb_get_bs}
\alias{nmb_get_bs}
\title{Accessor function for block scores}
\usage{
nmb_get_bs(nmb_object)
}
\arguments{
\item{nmb_object}{A `NipalsResult` object.}
}
\value{
a list of matrices containing block scores.
}
\description{
Retrieves the block scores as a list of matrices
from a `NipalsResult` object, typically output from `nipals_multiblock()`.
}
\examples{
data("NCI60")
data_blocks_mae <- simple_mae(data_blocks,row_format="sample",
                              colData=metadata_NCI60)
mcia_out <- nipals_multiblock(data_blocks_mae, num_PCs = 10)
block_scores <- nmb_get_bs(mcia_out)
}
