% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deflate_block_bl.R
\name{deflate_block_bl}
\alias{deflate_block_bl}
\title{Deflation via block loadings}
\usage{
deflate_block_bl(df, bl)
}
\arguments{
\item{df}{a data frame in "sample" x "variable" format}

\item{bl}{a block loadings vector in variable space}
}
\value{
the deflated data frame
}
\description{
Removes data from a data frame in the direction of a given
block loadings vector.
}
\details{
Subtracts the component of each row in the direction of a given
block loadings vector to yield a `deflated' data matrix.
}
\examples{
df <- matrix(rbinom(15, 1, prob = 0.3), ncol = 3)
block_loading <- rbinom(3, 1, prob = 0.3)
deflated_data <- deflate_block_bl(df, block_loading)

}
