% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSummary.R
\docType{methods}
\name{plotSummary}
\alias{plotSummary}
\alias{plotSummary,ANY-method}
\alias{plotSummary,character-method}
\alias{plotSummary,FastqcDataList-method}
\title{Plot the PASS/WARN/FAIL information}
\usage{
plotSummary(
  x,
  usePlotly = FALSE,
  labels,
  pwfCols,
  cluster = FALSE,
  dendrogram = FALSE,
  ...
)

\S4method{plotSummary}{ANY}(
  x,
  usePlotly = FALSE,
  labels,
  pwfCols,
  cluster = FALSE,
  dendrogram = FALSE,
  ...
)

\S4method{plotSummary}{character}(
  x,
  usePlotly = FALSE,
  labels,
  pwfCols,
  cluster = FALSE,
  dendrogram = FALSE,
  ...
)

\S4method{plotSummary}{FastqcDataList}(
  x,
  usePlotly = FALSE,
  labels,
  pwfCols,
  cluster = FALSE,
  dendrogram = FALSE,
  ...,
  gridlineWidth = 0.2,
  gridlineCol = "grey20"
)
}
\arguments{
\item{x}{Can be a \code{FastqcData}, \code{FastqcDataList} or character
vector of file paths}

\item{usePlotly}{\code{logical}. Generate an interactive plot using plotly}

\item{labels}{An optional named vector of labels for the file names.
All filenames must be present in the names.
File extensions are dropped by default.}

\item{pwfCols}{Object of class \code{\link[=PwfCols]{PwfCols()}} containing the colours
for PASS/WARN/FAIL}

\item{cluster}{\code{logical} default \code{FALSE}. If set to \code{TRUE},
fastqc data will be clustered using hierarchical clustering}

\item{dendrogram}{\code{logical} redundant if \code{cluster} is \code{FALSE}
if both \code{cluster} and \code{dendrogram} are specified as \code{TRUE}
then the dendrogram will be displayed.}

\item{...}{Used to pass various potting parameters to theme.}

\item{gridlineWidth, gridlineCol}{Passed to geom_hline and geom_vline to
determine width and colour of gridlines}
}
\value{
A ggplot2 object (\code{usePlotly = FALSE})
or an interactive plotly object (\code{usePlotly = TRUE})
}
\description{
Extract the PASS/WARN/FAIL summaries and plot them
}
\details{
This uses the standard ggplot2 syntax to create a three colour plot.
The output of this function can be further modified using the standard
ggplot2 methods if required.
}
\examples{

# Get the files included with the package
packageDir <- system.file("extdata", package = "ngsReports")
fl <- list.files(packageDir, pattern = "fastqc.zip", full.names = TRUE)

# Load the FASTQC data as a FastqcDataList object
fdl <- FastqcDataList(fl)

# Check the overall PASS/WARN/FAIL status
plotSummary(fdl)

}
