% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotInsertSize.R
\name{plotInsertSize}
\alias{plotInsertSize}
\alias{plotInsertSize,FastpData-method}
\alias{plotInsertSize,FastpDataList-method}
\title{Plot Insert Size Distributions}
\usage{
plotInsertSize(x, usePlotly = FALSE, labels, pattern = ".(fast|fq|bam).*", ...)

\S4method{plotInsertSize}{FastpData}(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  plotType = c("histogram", "cumulative"),
  counts = FALSE,
  plotTheme = theme_get(),
  expand.x = 0.01,
  expand.y = c(0, 0.05),
  ...
)

\S4method{plotInsertSize}{FastpDataList}(
  x,
  usePlotly = FALSE,
  labels,
  pattern = ".(fast|fq|bam).*",
  plotType = c("heatmap", "line", "cumulative"),
  plotTheme = theme_get(),
  scaleFill = NULL,
  scaleColour = NULL,
  cluster = FALSE,
  dendrogram = FALSE,
  heat_w = 8,
  ...
)
}
\arguments{
\item{x}{A FastpData or FastpDataList object}

\item{usePlotly}{\code{logical}. Generate an interactive plot using plotly}

\item{labels}{An optional named vector of labels for the file names.
All file names must be present in the names of the vector.}

\item{pattern}{Regex to remove from the end of any filenames}

\item{...}{Passed to \verb{geom*} functions during plotting}

\item{plotType}{Determine the plot type. Options vary with the input structure}

\item{counts}{logical(1) Plot read counts, or percentages (default)}

\item{plotTheme}{a \link[ggplot2]{theme} object}

\item{expand.x, expand.y}{Axis expansions}

\item{scaleFill}{Continuous scale used to fill heatmap cells. Defaults to the
"inferno" palette}

\item{scaleColour}{Discrete scale for adding line colours}

\item{cluster}{\code{logical} default \code{FALSE}. If set to \code{TRUE}, data will be
clustered using hierarchical clustering}

\item{dendrogram}{\code{logical} redundant if \code{cluster} is \code{FALSE}
if both \code{cluster} and \code{dendrogram} are specified as \code{TRUE} the dendrogram
will be displayed.}

\item{heat_w}{Width of the heatmap relative to other plot components}
}
\value{
A ggplot or plotly object
}
\description{
Plot the insert size distribution from one of Fastp reports
}
\details{
Takes a Fastp os a set of Fastp reports and plot insert size distributions.
Plots can be drawn as cumulative totals or the default histograms for a
single report, and as boxplots or heatmaps for a set of reports
}
\examples{
# Get the files included with the package
packageDir <- system.file("extdata", package = "ngsReports")
fl <- list.files(packageDir, pattern = "fastp.json.gz", full.names = TRUE)
fp <- FastpData(fl)
plotInsertSize(
  fp, counts = TRUE, fill = "steelblue4",
  plotTheme = theme(plot.title = element_text(hjust = 0.5))
)
plotInsertSize(fp, plotType = "cumulative")

}
