% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{.splitByTab}
\alias{.splitByTab}
\title{Split elements of a vector into a data.frame}
\usage{
.splitByTab(x, firstRowToNames = TRUE, tab = "\\\\t")
}
\arguments{
\item{x}{A character vector}

\item{firstRowToNames}{logical Should the first element be used for column
names}

\item{tab}{character The string used to represent the tab symbol}
}
\value{
A data frame
}
\description{
Split elements of a character vector by the tab separator
}
\details{
This will split a vector into a data.frame checking that every line
has the same number of separators.
By default the first element will be set as the column names.

This is designed to take input from \code{readLines()}
}
\examples{
x <- c("ColA\tColB", "Value1\tValue2")
ngsReports:::.splitByTab(x, firstRowToNames = TRUE)
ngsReports:::.splitByTab(x, firstRowToNames = FALSE)

}
\keyword{internal}
