% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TheoreticalGC.R
\docType{class}
\name{TheoreticalGC-class}
\alias{TheoreticalGC-class}
\title{The TheoreticalGC Object Class}
\value{
An object of class TheoreticalGC
}
\description{
Contains Theoretical GC content for a selection of species
}
\details{
Estimates are able to be retained for genomic and transcriptomic
sequences. Values are stored as frequencies.
}
\section{Slots}{

\describe{
\item{\code{Genome}}{A \code{data.frame} containing theoretical GC content for
genomic sequences}

\item{\code{Transcriptome}}{A \code{data.frame} containing theoretical GC content
for transcriptomic sequences}

\item{\code{mData}}{A \code{data.frame} containing metadata about all species in the
object}
}}

\examples{

## How to form an object using your own fasta file
faDir <- system.file("extdata", package = "ngsReports")
faFile <- list.files(faDir, pattern = "fasta", full.names = TRUE)
gen_df <- estGcDistn(faFile, n = 200)
gen_df <- dplyr::rename(gen_df, Athaliana = Freq)
mData_df <-
    data.frame(Name = "Athaliana", Genome = TRUE, Transcriptome = FALSE)
tr_df <- data.frame()
myGC <- new(
   "TheoreticalGC", Genome = gen_df, Transcriptome = tr_df, mData = mData_df)

}
