% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FastpData.R
\docType{class}
\name{FastpData-class}
\alias{FastpData-class}
\alias{FastpData}
\title{The FastpData Object Class}
\usage{
FastpData(x)
}
\arguments{
\item{x}{Path to a single zip archive or extracted folder for a individual
fastp report.}
}
\value{
An object of class FastpData
}
\description{
The FastpData Object Class
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\details{
This object class is the main object required for generating plots
and tables. Instantiation will first check for a .json file with the correct
data structure, and will then parse all the data into R as a \code{FastpData}
object. Fastp modules are contained as individual slots, which can be viewed
using \code{slotNames}. Sub-modules are also contained within many larger modules
with modules being based on the sections within a fastp html report

Individual modules can be returned using the function \code{getModule()}
and specifying which module/sub-module is required. See \code{\link[=getModule]{getModule()}} for
more details.
}
\section{Slots}{

\describe{
\item{\code{Summary}}{Contains three submodules 1) Before_filtering, 2)
After_filtering and 3) Filtering_result. All values presented in the initial
table for individual fastp reports are contained in other sections of the
report}

\item{\code{Adapters}}{Contains a tibble with all data from this module}

\item{\code{Duplication}}{Contains a tibble with all duplication results}

\item{\code{Insert_size}}{Contains a tibble with all insert size estimates}

\item{\code{Before_filtering,After_filtering}}{The modules can be selected for either
Read1 or Read2}

\item{\code{paired}}{logical(1) indicating whether the file is from paired-end
sequencing}

\item{\code{command}}{character(1) with the executed command}

\item{\code{version}}{character(1) with the fastp version being used}

\item{\code{path}}{Path to the Fastp report}
}}

