% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list.responses.factor.minimal.R
\name{list.responses.factor.minimal}
\alias{list.responses.factor.minimal}
\title{List factor responses (minimal)}
\usage{
list.responses.factor.minimal(
  annotation.df,
  groupings,
  method = "hypergeometric",
  min.size = 2,
  pth = Inf,
  verbose = TRUE,
  data = NULL,
  rounding = NULL
)
}
\arguments{
\item{annotation.df}{annotation data.frame with discrete factor levels, rows
named by the samples}

\item{groupings}{List of groupings. Each model should have a sample-cluster assignment matrix qofz, or a vector of cluster indices named by the samples.}

\item{method}{method for enrichment calculation}

\item{min.size}{minimum sample size for a response}

\item{pth}{p-value threshold; applied to adjusted p-value}

\item{verbose}{verbose}

\item{data}{data (samples x features; or a vector in univariate case)}

\item{rounding}{rounding digits}
}
\value{
A list with two elements: Table listing all associations between the factor levels and responses; multiple p-value adjustment method
}
\description{
List significantly associated responses for all factors and levels in the given annotation matrix
}
\references{
See citation('netresponse')
}
\author{
Contact: Leo Lahti \email{leo.lahti@iki.fi}
}
\keyword{utilities}
