% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggmgsa.R
\name{shapiro_screen}
\alias{shapiro_screen}
\title{Filter "non-normal" genes}
\usage{
shapiro_screen(x1, x2, sign.level = 0.001)
}
\arguments{
\item{x1}{expression matrix (condition 1)}

\item{x2}{expression matrix (condition 2)}

\item{sign.level}{sign.level in Shapiro-Wilk tests (default: sign.level=0.001)}
}
\value{
list consisting of
\item{x1.filt}{expression matrix (condition 1) after filtering}
\item{x2.filt}{expression matrix (condition 2) after filtering}
}
\description{
Filter "non-normal" genes
}
\details{
Discarding genes which have Shapiro-Wilk p-value (corrected for multiplicity)
smaller than sign.level in either of the two conditions. We used sign.level=0.001
in the GGMGSA paper.
}
\author{
n.stadler
}
\keyword{internal}
