% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffnet.R
\name{screen_shrink}
\alias{screen_shrink}
\title{Shrinkage approach for estimating Gaussian graphical model}
\usage{
screen_shrink(x, include.mean = NULL, trunc.method = "linear.growth",
  trunc.k = 5)
}
\arguments{
\item{x}{The input data. Needs to be a num.samples by dim.samples matrix.}

\item{include.mean}{Include mean in likelihood. TRUE / FALSE (default).}

\item{trunc.method}{None / linear.growth (default) / sqrt.growth}

\item{trunc.k}{truncation constant, number of samples per predictor (default=5)}
}
\value{
Returns a list with named elements 'rho.opt', 'wi', 'wi.orig'.
         Variable rho.opt=NULL (no tuning parameter involved). 
         The variables wi and wi.orig are matrices of size dim.samples by dim.samples 
         containing the truncated and untruncated inverse covariance matrix.
}
\description{
Shrinkage approach for estimating Gaussian graphical model
}
\author{
n.stadler
}
\keyword{Removed}
\keyword{examples}
\keyword{export}
\keyword{fixed.}
\keyword{internal}
\keyword{is}
\keyword{n=50}
\keyword{p=5}
\keyword{package}
\keyword{parcor}
\keyword{until}
\keyword{wihat=screen_shrink(x)$wi}
\keyword{x=matrix(rnorm(n*p),n,p)}
