% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggmgsa.R
\name{gsea.iriz}
\alias{gsea.iriz}
\title{Irizarry approach for gene-set testing}
\usage{
gsea.iriz(x1, x2, gene.sets, gene.names, gs.names = NULL,
  method.p.adjust = "fdr", alternative = "two-sided")
}
\arguments{
\item{x1}{Expression matrix (condition 1)}

\item{x2}{Expression matrix (condition 2)}

\item{gene.sets}{List of gene-sets}

\item{gene.names}{Gene names}

\item{gs.names}{Gene-set names}

\item{method.p.adjust}{Method for p-value adjustment (default='fdr')}

\item{alternative}{Default='two-sided' (uses two-sided p-values).}
}
\value{
List consisting of
\item{pval.shift}{p-values measuring shift}
\item{pval.scale}{p-values measuring scale}
\item{pval.combined}{combined p-values (minimum of pval.shift and pval.scale)}
}
\description{
Irizarry approach for gene-set testing
}
\details{
Implements the approach described in
"Gene set enrichment analysis made simple" by Irizarry et al (2011).
It tests for shift and/or change in scale of the distribution.
}
\examples{
n <- 100
p <- 20
x1 <- matrix(rnorm(n*p),n,p)
x2 <- matrix(rnorm(n*p),n,p)
gene.names <- paste('G',1:p,sep='')
gsets <- split(gene.names,rep(1:4,each=5))
fit <- gsea.iriz(x1,x2,gsets,gene.names)
fit$pvals.combined

x2[,1:3] <- x2[,1:3]+0.5#variables 1-3 of first gene-set are upregulated
fit <- gsea.iriz(x1,x2,gsets,gene.names)
fit$pvals.combined
}
\author{
n.stadler
}
