% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffregr.R
\name{diffregr_singlesplit}
\alias{diffregr_singlesplit}
\title{Differential Regression (single-split version).}
\usage{
diffregr_singlesplit(y1, y2, x1, x2, split1, split2,
  screen.meth = "screen_cvtrunc.lasso",
  compute.evals = "est2.my.ev3.diffregr",
  method.compquadform = "imhof", acc = 1e-04, epsabs = 1e-10,
  epsrel = 1e-10, show.warn = FALSE, n.perm = NULL, ...)
}
\arguments{
\item{y1}{Response vector condition 1.}

\item{y2}{Response vector condition 2.}

\item{x1}{Predictor matrix condition 1.}

\item{x2}{Predictor matrix condition 2.}

\item{split1}{Samples condition 1 used in screening-step.}

\item{split2}{Samples condition 2 used in screening-step.}

\item{screen.meth}{Screening method (default='screen_cvtrunc.lasso').}

\item{compute.evals}{Method to estimate the weights in the weighted-sum-of-chi2s distribution.
The default and (currently) the only available option 
is the method 'est2.my.ev3.diffregr'.}

\item{method.compquadform}{Algorithm for computing distribution function
of weighted-sum-of-chi2 (default='imhof').}

\item{acc}{See ?davies (default=1e-4).}

\item{epsabs}{See ?imhof (default=1e-10).}

\item{epsrel}{See ?imhof (default=1e-10).}

\item{show.warn}{Show warnings (default=FALSE)?}

\item{n.perm}{Number of permutation for "split-perm" p-value (default=NULL).}

\item{...}{Other arguments specific to screen.meth.}
}
\value{
List consisting of
\item{pval.onesided}{"One-sided" p-value.}
\item{pval.twosided}{"Two-sided" p-value. Ignore all "*.twosided results.}
\item{teststat}{2 times Log-likelihood-ratio statistics}
\item{weights.nulldistr}{Estimated weights of weighted-sum-of-chi2s.}
\item{active}{List of active-sets obtained in screening step.}
\item{beta}{Regression coefficients (MLE) obtaind in cleaning-step.}
}
\description{
Differential Regression (single-split version).
}
\details{
Intercepts in regression models are assumed to be zero (mu1=mu2=0).
You might need to center the input data prior to running
Differential Regression.
}
\examples{

##set seed
set.seed(1)

##number of predictors / sample size
p <- 100
n <- 80

##predictor matrices
x1 <- matrix(rnorm(n*p),n,p)
x2 <- matrix(rnorm(n*p),n,p)

##active-sets and regression coefficients
act1 <- sample(1:p,5)
act2 <- c(act1[1:3],sample(setdiff(1:p,act1),2))
beta1 <- beta2 <- rep(0,p)
beta1[act1] <- 0.5
beta2[act2] <- 0.5

##response vectors 
y1 <- x1\%*\%as.matrix(beta1)+rnorm(n,sd=1)
y2 <- x2\%*\%as.matrix(beta2)+rnorm(n,sd=1)

##run diffregr
split1 <- sample(1:n,50)#samples for screening (condition 1)
split2 <- sample(1:n,50)#samples for screening (condition 2)
fit <- diffregr_singlesplit(y1,y2,x1,x2,split1,split2)
fit$pval.onesided#p-value


}
\author{
n.stadler
}
