% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffnet.R
\name{diffnet_singlesplit}
\alias{diffnet_singlesplit}
\title{Differential Network for user specified data splits}
\usage{
diffnet_singlesplit(x1, x2, split1, split2,
  screen.meth = "screen_bic.glasso", compute.evals = "est2.my.ev3",
  algorithm.mleggm = "glasso_rho0", include.mean = FALSE,
  method.compquadform = "imhof", acc = 1e-04, epsabs = 1e-10,
  epsrel = 1e-10, show.warn = FALSE, save.mle = FALSE, ...)
}
\arguments{
\item{x1}{Data-matrix sample 1.
You might need to center and scale your data-matrix.}

\item{x2}{Data-matrix sample 2.
You might need to center and scale your data-matrix.}

\item{split1}{Samples (condition 1) used in screening step.}

\item{split2}{Samples (condition 2) used in screening step.}

\item{screen.meth}{Screening procedure. Options: 'screen_bic.glasso' (default),
'screen_cv.glasso', 'screen_shrink' (not recommended).}

\item{compute.evals}{Method to estimate the weights in the weighted-sum-of-chi2s distribution.
The default and (currently) the only available option 
is the method 'est2.my.ev3'.}

\item{algorithm.mleggm}{Algorithm to compute MLE of GGM. The algorithm 'glasso_rho' is the
default and (currently) the only available option.}

\item{include.mean}{Should sample specific means be included in hypothesis?
Use include.mean=FALSE (default and recommended) which assumes mu1=mu2=0
and tests the hypothesis H0: Omega_1=Omega_2.}

\item{method.compquadform}{Method to compute distribution function of weighted-sum-of-chi2s
(default='imhof').}

\item{acc}{See ?davies (default 1e-04).}

\item{epsabs}{See ?imhof (default 1e-10).}

\item{epsrel}{See ?imhof (default 1e-10).}

\item{show.warn}{Should warnings be showed (default=FALSE)?}

\item{save.mle}{Should MLEs be in the output list (default=FALSE)?}

\item{...}{Additional arguments for screen.meth.}
}
\value{
list consisting of
\item{pval.onesided}{p-value}
\item{pval.twosided}{ignore this output}
\item{teststat}{log-likelihood-ratio test statistic}
\item{weights.nulldistr}{estimated weights}
\item{active}{active-sets obtained in screening-step}
\item{sig}{constrained mle (covariance) obtained in cleaning-step}
\item{wi}{constrained mle (inverse covariance) obtained in cleaning-step}
\item{mu}{mle (mean) obtained in cleaning-step}
}
\description{
Differential Network for user specified data splits
}
\details{
Remark:

* If include.mean=FALSE, then x1 and x2 have mean zero and DiffNet tests
  the hypothesis H0: Omega_1=Omega_2. You might need to center x1 and x2.
* If include.mean=TRUE, then DiffNet tests the hypothesis
  H0: mu_1=mu_2 & Omega_1=Omega_2
* However, we recommend to set include.mean=FALSE and to test equality of the means
  separately. 
* You might also want to scale x1 and x2, if you are only interested in 
  differences due to (partial) correlations.
}
\examples{

##set seed
set.seed(1)

##sample size and number of nodes
n <- 40
p <- 10

##specifiy sparse inverse covariance matrices
gen.net <- generate_2networks(p,graph='random',n.nz=rep(p,2),
                              n.nz.common=ceiling(p*0.8))
invcov1 <- gen.net[[1]]
invcov2 <- gen.net[[2]]
plot_2networks(invcov1,invcov2,label.pos=0,label.cex=0.7)

##get corresponding correlation matrices
cor1 <- cov2cor(solve(invcov1))
cor2 <- cov2cor(solve(invcov2))

##generate data under alternative hypothesis
library('mvtnorm')
x1 <- rmvnorm(n,mean = rep(0,p), sigma = cor1)
x2 <- rmvnorm(n,mean = rep(0,p), sigma = cor2)

##run diffnet
split1 <- sample(1:n,20)#samples for screening (condition 1)
split2 <- sample(1:n,20)#samples for screening (condition 2)
dn <- diffnet_singlesplit(x1,x2,split1,split2)
dn$pval.onesided#p-value
}
\author{
n.stadler
}
