% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothAndRecombine.R
\name{smoothAndRecombine,matrix-method}
\alias{smoothAndRecombine,matrix-method}
\title{Perform network smoothing on network when the network genes and the
experiment genes aren't exactly the same.}
\usage{
\S4method{smoothAndRecombine}{matrix}(
  gene_expression,
  adj_matrix,
  alpha,
  smoothing.function = randomWalkBySolve,
  normalizeAdjMatrix = c("rows", "columns")
)
}
\arguments{
\item{gene_expression}{gene expession data to be smoothed
[N_genes x M_samples]}

\item{adj_matrix}{adjacenty matrix of network to perform smoothing over.
Will be column-normalized.
Rownames and colnames should be genes.}

\item{alpha}{network smoothing parameter (1 - restart probability in random
walk model.}

\item{smoothing.function}{must be a function that takes in data, adjacency
matrix, and alpha. Will be used to perform the
actual smoothing.}

\item{normalizeAdjMatrix}{which dimension (rows or columns) should the
adjacency matrix be normalized by. rows
corresponds to in-degree, columns to
out-degree.}

\item{filepath}{String: Path to location where hdf5 output file is supposed to be saved. 
Will be ignored when regular matrices or SummarizedExperiment are
used as input.}
}
\value{
matrix with network-smoothed gene expression data. Genes that are
         not present in smoothing network will retain original values.
}
\description{
The gene network might be defined only on a subset of genes that are
measured in any experiment. Further, an experiment might not measure all
genes that are present in the network. This function projects the experiment
data onto the gene space defined by the network prior to smoothing. Then,
it projects the smoothed data back into the original dimansions.
}
\keyword{internal}
