% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomWalkByMatrixInv.R
\name{randomWalkByMatrixInv,matrix-method}
\alias{randomWalkByMatrixInv,matrix-method}
\title{Smooth data on graph by computing the closed-form steady state
distribution of the random walk with restarts process.}
\usage{
\S4method{randomWalkByMatrixInv}{matrix}(
  f0,
  adjMatrix,
  alpha,
  normalizeAdjMatrix = c("rows", "columns")
)
}
\arguments{
\item{f0}{initial data matrix [NxM]}

\item{adjMatrix}{adjacency matrix of graph to network smooth on
will be column-normalized.}

\item{alpha}{smoothing coefficient (1 - restart probability of
random walk)}
}
\value{
network-smoothed gene expression
}
\description{
The closed-form solution is given by
  f_{ss} = (1 - alpha) * (I - alpha * A)^{-1} * f_0
and is computed by matrix inversion in this function.
}
\keyword{internal}
