% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projectFromNetworkRecombine.R
\name{projectFromNetworkRecombine,matrix-method}
\alias{projectFromNetworkRecombine,matrix-method}
\title{Combine gene expression from smoothed space (that of the network) with the
expression of genes that were not smoothed (not present in network)}
\usage{
\S4method{projectFromNetworkRecombine}{matrix}(original_expression, smoothed_expression)
}
\arguments{
\item{original_expression}{the non-smoothed expression}

\item{smoothed_expression}{the smoothed gene expression, in the space
of the genes defined by the network}

\item{filepath}{String: Path to location where hdf5 output file is supposed to be saved.
Will be ignored when regular matrices or SummarizedExperiment are
used as input.}
}
\value{
a matrix in the dimensions of original_expression, where values that
        are present in smoothed_expression are copied from there.
}
\description{
Combine gene expression from smoothed space (that of the network) with the
expression of genes that were not smoothed (not present in network)
}
\keyword{internal}
