% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assessGrouping.R
\name{assessGrouping}
\alias{assessGrouping}
\title{assessGrouping}
\usage{
assessGrouping(
  distances,
  annotations,
  measurement = "mean",
  output = "KS.pvalue",
  ctrl_iterations = 10000
)
}
\arguments{
\item{distances}{Data frame object with at least three columns where the
first three columns are sample 1 name, sample 2 name, and the distance
between them.}

\item{annotations}{Data frame object with at least two columns where the
first two columns are sample name and the category of the sample for
grouping. Sample names must match sample 1 and sample 2 names in distances
data frame.}

\item{measurement}{The measurement for comparison between cases and controls
and statistical analysis ("mean", "max", or "min). Default "mean"}

\item{output}{A string denoting what information will be returned: either a
list of test and control measurement distances ("measurements"), the p-value
of the Kolmogorov-Smirnov test comparing test and control distributions
("KS.pvalue"), or a ggplot object plotting the test and control distributions
("plot"). Default "KS.pvalue"}

\item{ctrl_iterations}{The number of iterations to test for the control
distribution; an integer. Default 10000.}
}
\value{
\item{output = "KS.pvalue"}{the p-value of the Kolmogorov-Smirnov
test comparing test and control distributions}
\item{output = "plot"}{a ggplot object plotting the test and control
    distributions}
\item{output = "measurements"}{a list or test and control measurement
distances}
}
\description{
Assess grouping of samples assigned to the same category
relative to random.
}
\examples{
## create random distance data frame
dist<-expand.grid(letters, letters)
dist$distance<-rnorm(nrow(dist))
annot<-data.frame(sample<-letters, category<- rep(1:13, 2))
## get KS p-value
assessGrouping(dist, annot)
## get plot of test vs control distributions
assessGrouping(dist, annot,
               output = "plot")

}
