% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndex_users.R
\name{ndex_user_list_groups}
\alias{ndex_user_list_groups}
\title{Get User's Group Memberships}
\usage{
ndex_user_list_groups(ndexcon, userId, type = NULL, start = NULL, size = NULL)
}
\arguments{
\item{ndexcon}{object of class NDExConnection link{ndex_connect}}

\item{userId}{character; unique ID (UUID) of the user}

\item{type}{character (optional)("MEMBER"|"GROUPADMIN"); constrains the type of the returned membership. If not set (or NULL), all permission types will be returned.}

\item{start}{integer (optional); specifies that the result is the nth page of the requested data.}

\item{size}{integer (optional); specifies the number of data items in each page.}
}
\value{
List of permissions of that user or empty object
}
\description{
Query finds groups for which the current user has the specified membership type. If the "type' parameter is omitted, all membership types will be returned. Returns a map which maps a group UUID to the membership type the authenticated user has.
}
\note{
Requires an authorized user! (ndex_connect with credentials)

Compatible to NDEx server version 2.0
}
\section{REST query}{

GET: ndex_config$api$user$group$list
}

\examples{
## Establish a server connection with credentials 
# ndexcon = ndex_connect('MyAccountName', 'MyPassword')
## Find user and get its id
# user = ndex_find_user_byName(ndexcon, 'MyAccountName')
# userId = user$externalId
## Find the user's groups and get one group id
# groups = ndex_user_list_groups(ndexcon, userId)
## $`ggggggg-rrrr-oooo-uuuu-pppppp111111`
## [1] "MEMBER"
##
## $`ggggggg-rrrr-oooo-uuuu-pppppp222222`
## [1] "GROUPADMIN"
# groupIds = names(groups)
## [1] "ggggggg-rrrr-oooo-uuuu-pppppp111111" "ggggggg-rrrr-oooo-uuuu-pppppp222222"
NULL
}
