% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndex_helper.r
\name{ndex_helper_encodeParams}
\alias{ndex_helper_encodeParams}
\title{Adds Parameters to an url}
\usage{
ndex_helper_encodeParams(url, params, ...)
}
\arguments{
\item{url}{character}

\item{params}{(nested) list; "params" section of a api function definition in the api configuration (See \link{ndex_config})}

\item{...}{parameters defined by name used in the config}
}
\value{
URL with encoded parameters as character
}
\description{
Encodes a given parameter within the url accordingly to the parameter configuration for the api.
}
\details{
The single parameter definitions are given as list by the "params" parameter. Each parameter is defined by a method, and, if applicable, a tag, a default value and/or an optional flag.
There are three keywords defining the method: replace, append or parameter.

replace: The String defined by "tag" can be found within the url and will be replaced by the given value of the parameter. E.g. the tag "#NETWORKID#" in the url "/network/#NETWORKID#/provenance" is replaced by a value (e.g. "aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee") given as network id, which leads to the url "/network/aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee/provenance". 

append: The given value of the parameter is appended to an url. Therefore the order of the parameters in the params definition is used. E.g. the url "/network/search" and the given values for "start" = 0 and "size" = 100 generates the following url: "/network/search/0/100"

parameter: Encodes the given parameters as url parameter using the specified tag as parameter descriptor. E.g. a parameter with the tag "username" and the value "SomeName" is encoded in the url "/user" as follows: "/user?username=SomeName"

It is also possible to set parameter as optional (except for replace), or define default values. Values are assigned to the parameters using the parameter name in the ... parameter.
}
\note{
This function is internal.
}
\examples{
## replace
url = "http://en.wikipedia.org/#NETWORKID#/index.php"
params = list(    network=list(    tag="#NETWORKID#", method="replace"))
values = c(network='aaaa-bb-cc-dddddd', bla='This is not used!')
ndexr:::ndex_helper_encodeParams(url, params=params, values)
## "http://en.wikipedia.org/aaaa-bb-cc-dddddd/index.php"

params = list( network=list( tag="#NETWORKID#", method="replace", default="xxxx-xx-xx-xxxxxx"))
values = c(bla='This is not used!')
ndexr:::ndex_helper_encodeParams(url, params=params, values)
## "http://en.wikipedia.org/xxxx-xx-xx-xxxxxx/index.php"
 
## parameter
url = "http://en.wikipedia.org/w/index.php"
params = list(    network=list(    tag="network", method="parameter"))
values = c(network='aaaa-bb-cc-dddddd', bla='This is not used!')
ndexr:::ndex_helper_encodeParams(url, params=params, values)
## "http://en.wikipedia.org/w/index.php?network=aaaa-bb-cc-dddddd"
  
values = c(bla='This is not used!')
params = list(    network=list(    tag="network", method="parameter", optional=TRUE))
ndexr:::ndex_helper_encodeParams(url, params=params, values)
## "http://en.wikipedia.org/w/index.php"
  
params = list(  network=list(  tag="network", method="parameter", default="xxxx-xx-xx-xxxxxx"))
ndexr:::ndex_helper_encodeParams(url, params=params, values)
## "http://en.wikipedia.org/w/index.php?network=xxxx-xx-xx-xxxxxx"
  
ndexr:::ndex_helper_encodeParams(url, params=params, values)
values = c(network='aaaa-bb-cc-dddddd', bla='This is not used!')
## "http://en.wikipedia.org/w/index.php?network=aaaa-bb-cc-dddddd"
  
## append
url = "http://en.wikipedia.org/w/index.php"
params = list(    network=list(    method="append"))
values = c(network='aaaa-bb-cc-dddddd', bla='This is not used!')
ndexr:::ndex_helper_encodeParams(url, params=params, values)
## "http://en.wikipedia.org/w/index.php/aaaa-bb-cc-dddddd"
  
values = c(bla='This is not used!')
params = list(    network=list(    method="append", optional=TRUE))
ndexr:::ndex_helper_encodeParams(url, params=params, values)
## "http://en.wikipedia.org/w/index.php"
  
params = list(    network=list(    method="append", default="xxxx-xx-xx-xxxxxx"))
ndexr:::ndex_helper_encodeParams(url, params=params, values)
## "http://en.wikipedia.org/w/index.php/xxxx-xx-xx-xxxxxx"
  
values = c(network='aaaa-bb-cc-dddddd', bla='This is not used!')
ndexr:::ndex_helper_encodeParams(url, params=params, values)
## "http://en.wikipedia.org/w/index.php/aaaa-bb-cc-dddddd"
}
\keyword{internal}
