% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndex_networks_simple_operations.r
\name{ndex_get_network}
\alias{ndex_get_network}
\title{Get complete network}
\usage{
ndex_get_network(ndexcon, networkId)
}
\arguments{
\item{ndexcon}{object of class NDExConnection link{ndex_connect}}

\item{networkId}{unique ID of the network}
}
\value{
\code{\link[RCX]{RCX-object}} object
}
\description{
Returns the specified network as \link[RCX]{RCX-object}.
}
\details{
\strong{Note: In future `ndexr` uses the \link[RCX]{RCX-object} from the corresponding package to handle the networks!}

This is performed as a monolithic operation, so it is typically advisable for applications to first use the getNetworkSummary method to check the node and edge counts for a network before retrieving the network.
Uses getEdges (this procedure will return complete network with all elements)
Nodes use primary ID of the base term ('represents' element)
Edges use primary ID of the base term ('predicate', or 'p' element)
Mapping table for the nodes is retrieved ('alias' and 'related' terms) to facilitate conversions/data mapping
}
\note{
Compatible to NDEx server version 1.3 and 2.0
}
\section{REST query}{

GET: ndex_config$api$network$get
}

\examples{
## Establish a server connection
ndexcon = ndex_connect()
## Find a network and get its UUID
networks = ndex_find_networks(ndexcon,"p53", "nci-pid")
networkId = networks[1,"externalId"]
## Get the network data 
rcx = ndex_get_network(ndexcon, networkId) 
}
