% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndex_networks.r
\name{ndex_find_networks}
\alias{ndex_find_networks}
\title{Search networks in NDEx (by description)}
\usage{
ndex_find_networks(ndexcon, searchString = "", accountName, start, size)
}
\arguments{
\item{ndexcon}{object of class NDExConnection link{ndex_connect}}

\item{searchString}{string by which to search}

\item{accountName}{string (optional); constrain search to networks administered by this account}

\item{start}{integer (optional); specifies that the result is the nth page of the requested data. The default value is 0}

\item{size}{integer (optional); specifies the number of data items in each page. The default value is 100}
}
\value{
Data frame with network information: ID, name, whether it is public, edge and node count; source and format of network. NULL if no networks are found.
}
\description{
This functions searches the public networks on an NDEx server for networks containing the supplied search string. T
his search can be limited to certain accounts as well as in length.
}
\note{
Compatible to NDEx server version 1.3 and 2.0

Search strings may be structured
}
\section{REST query}{

GET: ndex_config$api$search$network$search
}

\examples{
ndexcon = ndex_connect()
networks = ndex_find_networks(ndexcon,"p53") 
}
