% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndex_groups.R
\name{ndex_find_groups}
\alias{ndex_find_groups}
\title{Search groups in NDEx}
\usage{
ndex_find_groups(ndexcon, searchString = "", start, size)
}
\arguments{
\item{ndexcon}{object of class NDExConnection link{ndex_connect}}

\item{searchString}{string by which to search}

\item{start}{integer (optional); specifies that the result is the nth page of the requested data. The default value is 0}

\item{size}{integer (optional); specifies the number of data items in each page. The default value is 100}
}
\value{
Data frame with group information; NULL if no groups are found.
}
\description{
Returns a SearchResult object which contains an array of Group objects
}
\note{
Compatible to NDEx server version 1.3 and 2.0

Search strings may be structured
}
\section{REST query}{

GET: ndex_config$api$search$user
}

\examples{
## Establish a server connection
ndexcon = ndex_connect()
## Find a group
groups = ndex_find_groups(ndexcon,"Ideker Lab")
names(groups)
## [1] "properties"  "groupName"  "image"             "website"       "description"
## [6] "externalId"  "isDeleted"  "modificationTime"  "creationTime" 
}
