% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/ncdfFlowSet-accessors.R
\docType{class}
\name{ncdfFlowSet-class}
\alias{ncdfFlowSet-class}
\alias{show,ncdfFlowSet-method}
\alias{show}
\title{a class for storing flow cytometry raw data in HDF5 format}
\usage{
\S4method{show}{ncdfFlowSet}(object)
}
\arguments{
\item{object}{\code{ncdfFlowSet}
show,ncdfFlowSet-method}
}
\description{
This class is a subclass of
  \code{\link{flowSet}}. It stores the raw data in cdf file instead of memory so that the analysis tools
  provided by flowCore based packages can be used in the study that produces hundreds or thousands FCS files.
}
\section{Slots}{

 \describe{

\item{\code{file}:}{A character containing the ncdf file name.}
\item{\code{maxEvents}:}{An integer containing the maximum number of events of all samples stored in this ncdfFlowSet object }
\item{\code{flowSetId}:}{A character for the id of ncdfFlowSet object }
\item{\code{indices}:}{Object of class \code{"environment"} containing events indices of each sample stored as \code{"raw"} vector. Each index value is either TURE or FALSE and the entire indices vector is used to subset the raw data.
                        the indices vector of each sample is NA by default when the ncdfFlowSet first created.It is assigned with actual value when ncdfFlowSet object is subsetted by \code{\link{Subset}}
                         or other subsetting methods.}
\item{\code{origSampleVector}:}{A character vector containing the sample names,
                                 which indicates the original order of samples physically stored in cdf format}
\item{\code{origColnames}:}{A character vector containing the flow channel names,
                             which indicates the original order of columns physically stored in cdf format}

\item{\code{frames}:}{Object of class \code{"environment"}, which replicates the "frame" slot in \code{\link{flowSet}},
                     except that  \code{\link[=exprs,flowFrame-method]{exprs}} matrix is empty and the actual data is stored in cdf file. }
\item{\code{phenoData}:}{see \code{\link[=phenoData,flowSet-method]{phenoData}}}
}
}

\section{Extends}{
 
Class \code{"\linkS4class{flowSet}"}, directly.
}

