% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncdfFlowSet-accessors.R
\name{as.flowSet}
\alias{as.flowSet}
\title{convert from a \code{ncdfFlowSet} to a \code{flowSet}}
\usage{
as.flowSet(from, top)
}
\arguments{
\item{from}{a \code{ncdfFlowSet}}

\item{top}{\code{integer} specifies a certain number of samples are evenly selected for the coersion.
If this argument is missing, then coerce all the samples within the \code{ncdfFlowSet}.
It is to be used with caution because it can incur the huge memory consumption given  the \code{flowSet} is all-in-memory data structure.}
}
\description{
The main purpose of this API is to convert the archived data (stored in \code{ncdfFlowSet}) to \code{flowSet}
when the speed is more concerned than memory effieciency. 
Although \code{ncdfFlowSet} is designed to minimize the disk-IO cost, so usually it is not necessary to do such coersion.
}
\examples{
data(GvHD)
nc1 <- ncdfFlowSet(GvHD[1:4])
fs <- as.flowSet(nc1)
}
