% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncGTWutility.R
\name{meanCorOl}
\alias{meanCorOl}
\title{Compute average pairwise correlation and overlapping area}
\usage{
meanCorOl(ncGTWinput, sampleRt)
}
\arguments{
\item{ncGTWinput}{A list in which each element is a \code{\link{ncGTWinput}}
object.}

\item{sampleRt}{A list of the same length as the sample number in which each
element is a vector corresponding to the sample raw/adjusted RT.}
}
\value{
A list in which the first element is average pairwise correlation,
and the second one is average overlapping area.
}
\description{
This function computes average pairwise correlation and overlapping area of
each sample pair.
}
\details{
This function computes the pairwise correlation and overlapping area
of each sample pair from the input feature, and then takes average.
}
\examples{
# obtain data
data('xcmsExamples')
xcmsLargeWin <- xcmsExamples$xcmsLargeWin
xcmsSmallWin <- xcmsExamples$xcmsSmallWin
ppm <- xcmsExamples$ppm

# detect misaligned features
excluGroups <- misalignDetect(xcmsLargeWin, xcmsSmallWin, ppm)

# obtain the paths of the sample files
filepath <- system.file("extdata", package = "ncGTW")
file <- list.files(filepath, pattern="mzxml", full.names=TRUE)

tempInd <- matrix(0, length(file), 1)
for (n in seq_along(file)){
    tempCha <- file[n]
    tempLen <- nchar(tempCha)
    tempInd[n] <- as.numeric(substr(tempCha, regexpr("example", tempCha) + 7,
        tempLen - 6))
}
# sort the paths by data acquisition order
file <- file[sort.int(tempInd, index.return = TRUE)$ix]

# load the sample profiles
ncGTWinputs <- loadProfile(file, excluGroups)

XCMSCor <- matrix(0, length(ncGTWinputs), 1)
XCMSOl <- matrix(0, length(ncGTWinputs), 1)
for (n in seq_along(ncGTWinputs)){
    XCMSmean <- meanCorOl(ncGTWinputs[[n]],
        slot(xcmsLargeWin, 'rt')$corrected)
    XCMSCor[n] <- XCMSmean$cor
    XCMSOl[n] <- XCMSmean$ol
}
}
