% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mzIDpeptides.R
\docType{class}
\name{mzIDpeptides-class}
\alias{length,mzIDpeptides-method}
\alias{modifications,mzIDpeptides-method}
\alias{mzIDpeptides-class}
\alias{peptides,mzIDpeptides-method}
\alias{show,mzIDpeptides-method}
\title{A class to store peptide information from an mzIdentML file}
\usage{
\S4method{show}{mzIDpeptides}(object)

\S4method{length}{mzIDpeptides}(x)

\S4method{peptides}{mzIDpeptides}(object, safeNames = TRUE)

\S4method{modifications}{mzIDpeptides}(object)
}
\arguments{
\item{object}{An mzIDpeptides object}

\item{x}{An mzIDpeptides object}

\item{safeNames}{Should column names be lowercased to ensure compatibility
between v1.0 and v1.1 files?}
}
\description{
This class handles parsing and storage of peptide information from mzIDentML 
files, residing at the /x:MzIdentML/x:SequenceCollection/x:Peptide node.
}
\details{
The information is stored in a dataframe with an id, an optinal name and the 
amino acid sequence of the peptide. Alongside a list is stored with 
modification information of each peptide. Each row in the dataframe has a
corresponding entry en the list. If no modification of the peptide is present
the entry is NULL, if a modification is present the entry is a dataframe, 
listing the different modifications of the peptide.
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: Short summary of the content of the object

\item \code{length}: Report the number of peptides

\item \code{peptides}: Get the peptides identified.

\item \code{modifications}: Get the modification on the identified peptides
}}
\section{Slots}{

\describe{
\item{\code{peptides}}{A data.frame containing all peptides used in the search}

\item{\code{modifications}}{A list containing possible modifications of the peptides 
listed in @peptides}
}}
\section{Objects from the class}{

Objects of mzIDpeptides are not meant to be created explicitly but as part of
the \code{\link{mzID-class}}. Still object can be created with the 
constructor \code{\link{mzIDpeptides}}.
}
\seealso{
\code{\link{mzIDpeptides}}

Other mzID.classes: \code{\link{mzID-class}},
  \code{\link{mzIDCollection-class}},
  \code{\link{mzIDdatabase-class}},
  \code{\link{mzIDevidence-class}},
  \code{\link{mzIDparameters-class}},
  \code{\link{mzIDpsm-class}}
}

